/*
 * Decompiled with CFR 0.152.
 */
package com.anotherera.core;

import com.anotherera.core.AnotherCommonBugFix;
import com.anotherera.core.ConfigMap;
import com.anotherera.core.Transform;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ACBFClassTransformer
implements IClassTransformer {
    private static Logger log;
    private static ScriptEngine scriptEngine;
    private static Map<String, TransformResource> classTransform;
    private static Map<String, List<String>> enableTransform;
    private static Map<String, List<ConfigComment>> configMap;
    public static boolean checkFixPacket;
    public static Map<String, String> fixPacketsMd5;
    public static Map<String, String> enableTransformMd5;
    private static MethodHandles.Lookup lookup;
    private static boolean initSuccess;
    private static boolean inTransform;

    public static void init() {
        File configDir;
        File configFile;
        File resourceDir;
        ACBFClassTransformer.initField();
        try {
            resourceDir = ACBFClassTransformer.getResourceDir();
            configFile = ACBFClassTransformer.getConfigFile();
            configDir = ACBFClassTransformer.getPacketConfigDir();
        }
        catch (IOException e) {
            log.error("Init failed");
            return;
        }
        ACBFClassTransformer.loadConfig(configFile);
        boolean configChange = ACBFClassTransformer.loadFixPackets(resourceDir, configDir);
        if (configChange) {
            ACBFClassTransformer.saveConfig(configFile);
        }
        ACBFClassTransformer.grnerateConfigMd5();
        initSuccess = true;
    }

    private static void initField() {
        log = LogManager.getLogger((String)"anothercommonbugfix");
        scriptEngine = new ScriptEngineManager(null).getEngineByName("nashorn");
        classTransform = Maps.newHashMap();
        enableTransform = Maps.newHashMap();
        configMap = Maps.newHashMap();
        fixPacketsMd5 = Maps.newHashMap();
        enableTransformMd5 = Maps.newHashMap();
        lookup = MethodHandles.lookup();
        initSuccess = false;
        inTransform = false;
    }

    private static File getResourceDir() throws IOException {
        File resourceDir = new File(AnotherCommonBugFix.mcLocation, "fixResource");
        if (resourceDir.isFile()) {
            resourceDir.delete();
        }
        if (!resourceDir.exists()) {
            resourceDir.mkdir();
        }
        if (resourceDir.isFile()) {
            throw new IOException("fixResource not a dir");
        }
        if (!resourceDir.exists()) {
            throw new IOException("fixResource not exists");
        }
        return resourceDir;
    }

    private static File getConfigFile() throws IOException {
        File configFile = new File(AnotherCommonBugFix.mcLocation, "config/AnotherCommonBugFix.cfg");
        if (configFile.exists() && configFile.isDirectory()) {
            configFile.delete();
        }
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            configFile.createNewFile();
        }
        return configFile;
    }

    private static File getPacketConfigDir() throws IOException {
        File configDir = new File(AnotherCommonBugFix.mcLocation, "config/AnotherCommonBugFix");
        if (configDir.exists() && configDir.isFile()) {
            configDir.delete();
        }
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return configDir;
    }

    private static void loadConfig(File configFile) {
        log.info("Load config");
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), "utf-8"));){
            String line = null;
            String comment = null;
            String curPacketFileName = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                if (line.isEmpty()) continue;
                int index = line.indexOf(35);
                if (index == 0) {
                    comment = line;
                    continue;
                }
                if (index > 0) {
                    line = line.substring(0, index).trim();
                }
                if (line.equals("checkFixPacket")) {
                    comment = null;
                    checkFixPacket = true;
                    log.info("enable checkFixPacket");
                    continue;
                }
                if (line.startsWith("-")) {
                    if (curPacketFileName == null) {
                        comment = null;
                        log.warn("Unknow group transform:" + line.substring(1));
                        continue;
                    }
                    enableTransform.get(curPacketFileName).add(line.substring(1));
                    configMap.get(curPacketFileName).add(new ConfigComment(comment, line.substring(1)));
                    log.info("Enable transform:" + curPacketFileName + ":" + line.substring(1));
                    comment = null;
                    continue;
                }
                if (!line.endsWith(".zip")) continue;
                comment = null;
                curPacketFileName = line;
                enableTransform.put(curPacketFileName, Lists.newArrayList());
                configMap.put(curPacketFileName, Lists.newArrayList());
            }
        }
        catch (IOException e) {
            log.warn("Load config failed");
        }
    }

    private static void saveConfig(File configFile) {
        log.info("Save config");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "utf-8"));){
            for (Map.Entry<String, List<ConfigComment>> entry : configMap.entrySet()) {
                bw.write(entry.getKey());
                bw.newLine();
                for (ConfigComment name : entry.getValue()) {
                    if (name.comment != null) {
                        bw.write(name.comment);
                        bw.newLine();
                    }
                    bw.write("-");
                    bw.write(name.config);
                    bw.newLine();
                }
                bw.newLine();
            }
        }
        catch (IOException e) {
            log.warn("Save config failed");
        }
    }

    private static boolean loadFixPackets(File resourceDir, File configDir) {
        log.info("Load fix packet");
        boolean configChange = false;
        for (File file2 : resourceDir.listFiles(file -> file.isFile() && file.getName().endsWith(".zip"))) {
            Throwable throwable;
            String[] map;
            int index;
            boolean isNew;
            ZipFile zipFile;
            try {
                zipFile = new ZipFile(file2);
            }
            catch (IOException e) {
                log.warn("Failed to open packet:" + file2.getName());
                continue;
            }
            ZipEntry entry = zipFile.getEntry("transform.cfg");
            if (entry == null) {
                log.warn("Not a fix packet:" + file2.getName());
                continue;
            }
            try (FileInputStream fis = new FileInputStream(file2);){
                fixPacketsMd5.put(file2.getName(), DigestUtils.md5Hex((InputStream)fis));
            }
            catch (IOException e) {
                fixPacketsMd5.put(file2.getName(), "ERROR");
                log.warn("Failed to grnerate Packet Md5:" + file2.getName());
            }
            try {
                ((LaunchClassLoader)Thread.currentThread().getContextClassLoader()).addURL(file2.toURI().toURL());
            }
            catch (MalformedURLException e1) {
                log.warn("Failed to add url:" + file2.getName());
            }
            boolean bl = isNew = !enableTransform.containsKey(file2.getName());
            if (isNew) {
                log.info("Find new packet:" + file2.getName());
                log.info("Add this packet to config:" + file2.getName());
                enableTransform.put(file2.getName(), Lists.newArrayList());
                configMap.put(file2.getName(), Lists.newArrayList());
                configChange = true;
            } else {
                log.info("Find packet:" + file2.getName());
            }
            boolean hasConfig = false;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), "utf-8"));){
                ConfigMap.instance.selectPacket = file2.getName();
                String line = null;
                String comment = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                    if (line.isEmpty()) continue;
                    index = line.indexOf(35);
                    if (index == 0) {
                        comment = line;
                        continue;
                    }
                    if (index > 0) {
                        line = line.substring(0, index).trim();
                    }
                    if (line.startsWith("info:")) {
                        comment = null;
                        log.info(line.substring(5));
                        continue;
                    }
                    if (line.startsWith("config:")) {
                        map = (line = line.substring(7)).split(" +");
                        if (map.length == 1) {
                            hasConfig = true;
                            ConfigMap.instance.put(map[0], "");
                            continue;
                        }
                        if (map.length != 2) continue;
                        hasConfig = true;
                        ConfigMap.instance.put(map[0], map[1]);
                        continue;
                    }
                    map = line.split(" +");
                    if (map.length == 2) {
                        if (isNew) {
                            log.info("Load new transform:" + line);
                            enableTransform.get(file2.getName()).add(map[0]);
                            configMap.get(file2.getName()).add(new ConfigComment(comment, map[0]));
                            classTransform.put(map[0], new TransformResource(file2, zipFile, map[1]));
                        } else if (enableTransform.get(file2.getName()).contains(map[0])) {
                            if (classTransform.containsKey(map[0])) {
                                log.warn("Repeat transform" + line + ", use transform in " + file2.getName());
                            } else {
                                log.info("Load transform:" + line);
                            }
                            classTransform.put(map[0], new TransformResource(file2, zipFile, map[1]));
                        } else {
                            log.info("Disable transform:" + line);
                        }
                        comment = null;
                        continue;
                    }
                    if (map.length != 1) continue;
                    try {
                        Class<?> transformClazz = Class.forName(line);
                        Object instance = transformClazz.newInstance();
                        boolean enable = false;
                        if (isNew) {
                            log.info("Load new transform:" + line);
                            enableTransform.get(file2.getName()).add(line);
                            configMap.get(file2.getName()).add(new ConfigComment(comment, line));
                            enable = true;
                        } else if (enableTransform.get(file2.getName()).contains(line)) {
                            log.info("Load transform:" + line);
                            enable = true;
                        } else {
                            log.info("Disable transform:" + line);
                            enable = false;
                        }
                        if (enable) {
                            for (Method method : transformClazz.getMethods()) {
                                Transform transform = method.getAnnotation(Transform.class);
                                if (transform == null) continue;
                                String name = transform.value();
                                if (classTransform.containsKey(name)) {
                                    log.warn("Repeat transform" + line + ", use transform in " + file2.getName());
                                }
                                classTransform.put(name, new TransformResource(file2, zipFile, lookup, transformClazz, method, instance));
                            }
                        }
                        comment = null;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {}
                }
            }
            catch (IOException e) {
                log.warn("Load packet transform failed:" + file2.getName());
            }
            if (!hasConfig) continue;
            File packetConfigFile = new File(configDir, file2.getName() + ".cfg");
            if (packetConfigFile.exists()) {
                try {
                    throwable = null;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(packetConfigFile), "utf-8"));){
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            if (line.charAt(0) == '\ufeff') {
                                line = line.substring(1);
                            }
                            if (line.isEmpty() || (index = line.indexOf(35)) == 0) continue;
                            if (index > 0) {
                                line = line.substring(0, index).trim();
                            }
                            if ((map = line.split(" +")).length == 1) {
                                ConfigMap.instance.put(map[0], "");
                                continue;
                            }
                            if (map.length != 2) continue;
                            ConfigMap.instance.put(map[0], map[1]);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    log.warn("Load packet config failed:" + file2.getName());
                }
                continue;
            }
            try {
                throwable = null;
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(packetConfigFile), "utf-8"));){
                    for (Map.Entry<String, String> config : ConfigMap.instance.config.get(ConfigMap.instance.selectPacket).entrySet()) {
                        bw.write(config.getKey());
                        bw.write(" ");
                        bw.write(config.getValue());
                        bw.newLine();
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                log.warn("Save config failed");
            }
        }
        return configChange;
    }

    private static void grnerateConfigMd5() {
        for (Map.Entry<String, List<String>> entry : enableTransform.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (String name : entry.getValue()) {
                sb.append(name).append(";");
            }
            enableTransformMd5.put(entry.getKey(), DigestUtils.md5Hex((String)sb.toString()));
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        byte[] ofBytes;
        if (initSuccess && (ofBytes = this.getClassBytes(name, transformedName, basicClass)) != null) {
            log.info("Transform:" + transformedName);
            return ofBytes;
        }
        return basicClass;
    }

    /*
     * Exception decompiling
     */
    private synchronized byte[] getClassBytes(String name, String transformedName, byte[] basicClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 17[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    private byte[] getTransformingBytes(InputStream in, long size, String name, String transformedName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int len = 0;
        while ((len = in.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        baos.close();
        if ((long)bytes.length != size) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof LaunchClassLoader) {
            IClassTransformer ict;
            LaunchClassLoader lcl = (LaunchClassLoader)cl;
            Iterator iterator = lcl.getTransformers().iterator();
            while (iterator.hasNext() && !((ict = (IClassTransformer)iterator.next()) instanceof ACBFClassTransformer)) {
                bytes = ict.transform(name, transformedName, bytes);
            }
            return bytes;
        }
        return null;
    }

    public static class ConfigComment {
        public String comment;
        public String config;

        public ConfigComment(String comment, String config) {
            if (comment != null && comment.isEmpty()) {
                comment = null;
            }
            this.comment = comment;
            this.config = config;
        }
    }

    public static class TransformResource {
        public static MethodType TRANSFORM_METHOD_TYPE = MethodType.methodType(byte[].class, byte[].class);
        public static String TRANSFORM_METHOD_NAME = "transform";
        public File file;
        public ZipFile zipFile;
        public String name;
        private MethodHandle handle;
        private boolean cached;

        public TransformResource(File file, ZipFile zipFile, String name) {
            this.file = file;
            this.zipFile = zipFile;
            this.name = name;
            this.handle = null;
            this.cached = false;
        }

        public TransformResource(File file, ZipFile zipFile, MethodHandles.Lookup lookup, Class<?> clazz, Method method, Object source) {
            this.file = file;
            this.zipFile = zipFile;
            this.name = null;
            try {
                Class<?>[] parameters = method.getParameterTypes();
                if (parameters.length == 1 && parameters[0] == byte[].class && method.getReturnType() == byte[].class) {
                    if ((method.getModifiers() & 8) == 8) {
                        this.handle = lookup.findStatic(clazz, method.getName(), TRANSFORM_METHOD_TYPE);
                    } else {
                        if (source == null) {
                            source = clazz.newInstance();
                        }
                        this.handle = lookup.findVirtual(clazz, method.getName(), TRANSFORM_METHOD_TYPE).bindTo(source);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            this.cached = true;
        }

        public MethodHandle getHandle() {
            if (!(this.cached || this.name.contains("/") || this.name.endsWith(".class") || this.name.endsWith(".js"))) {
                try {
                    this.handle = lookup.findStatic(Class.forName(this.name), TRANSFORM_METHOD_NAME, TRANSFORM_METHOD_TYPE);
                    this.cached = true;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return this.handle;
        }
    }
}

